---
generated_at: 2026-02-02 10:05:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：6-Storage Version GC Controller バッチ設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **syncStorageVersion関数の詳細実装**：storageVersionWorkerの内部処理は読み取り範囲外

## 2) 参照した情報（Evidence一覧）

- E-01: `pkg/controller/storageversiongc/gc_controller.go` - Controller構造体（L47-L57）
- E-02: `pkg/controller/storageversiongc/gc_controller.go` - NewStorageVersionGC関数（L60-L92）
- E-03: `pkg/controller/storageversiongc/gc_controller.go` - Run関数（L95-L126）
- E-04: `pkg/controller/storageversiongc/gc_controller.go` - processDeletedLease関数（L174-L200）
- E-05: `pkg/controller/storageversiongc/gc_controller.go` - processNextLease/processNextStorageVersion（L133-L172）
- E-06: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` - No.6 エントリ

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Controller構造体がkubeclientset, leaseLister, leaseQueue, storageVersionQueueを保持 | E-01 | ○ |
| C-02 | LeaseのDeleteFuncのみ登録 | E-02 | ○ |
| C-03 | StorageVersionのAddFunc/UpdateFunc登録 | E-02 | ○ |
| C-04 | leaseQueueキュー名: storage_version_garbage_collector_leases | E-02 | ○ |
| C-05 | storageVersionQueueキュー名: storage_version_garbage_collector_storageversions | E-02 | ○ |
| C-06 | Run関数でWaitForCacheSyncの後にワーカー起動 | E-03 | ○ |
| C-07 | leaseWorkerとstorageVersionWorkerの2つのgoroutine | E-03 | ○ |
| C-08 | 各ワーカーが1秒間隔で実行 | E-03 | ○ |
| C-09 | 2ワーカー間の競合は許容 | E-03 | ○ |
| C-10 | processDeletedLeaseでリース復活チェック | E-04 | ○ |
| C-11 | 全StorageVersion一覧を取得してAPIServerID一致分を除去 | E-04 | ○ |
| C-12 | hasStaleRecordの判定ロジック | E-04 | ○ |
| C-13 | Leaseのkube-system Namespace | E-04 | ○ |
| C-14 | processNextLease/processNextStorageVersionのForget/AddRateLimitedパターン | E-05 | ○ |
| C-15 | 開始ログ "Starting storage version garbage collector" | E-03 | ○ |
| C-16 | 停止ログ "Shutting down storage version garbage collector" | E-03 | ○ |
| C-17 | エラー時のutilruntime.HandleError | E-05 | ○ |
| C-18 | syncStorageVersion関数の詳細実装 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- syncStorageVersion関数（storageVersionWorker側のメイン処理）の実装は読み取り範囲外。
  - 候補：`pkg/controller/storageversiongc/gc_controller.go` のL200以降

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - コントローラー構造と初期化・起動フローは正確
- 0: 低リスク - processDeletedLeaseのロジックはソースコードと一致

## 6) レビュアーチェックリスト（最小）
- [ ] syncStorageVersion関数の実装を確認し、リース存在チェックのロジックを検証
- [ ] processDeletedLeaseの後半部分（StorageVersion削除条件）を確認
- [ ] onDeleteLease/onAddStorageVersion/onUpdateStorageVersionの実装を確認
